//
//  Title.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//


import SpriteKit
import SPCScene
import Canvas


public class Title : Scene, SceneAnimating {
    static let backgrounds = [#imageLiteral(resourceName: "StartingScreen_1024-0.png"), #imageLiteral(resourceName: "StartingScreen_1024-1.png")]
    static let play = [#imageLiteral(resourceName: "play-button-up.png"), #imageLiteral(resourceName: "play-button-pressed.png")]
    var titleCard: Graphic
    var playButton: GraphicButton? = nil
    
    public override init() {
        titleCard = Graphic(image: Image(with: Title.backgrounds[0]), name: "Main title background")
        
        super.init(size: Scene.sceneSize)
        
        self.place(titleCard, at: Point.center)
    }

    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // MARK: - SceneAnimating
    
    public var sceneTransition: SKTransition?
    public var animationDelegate: SceneAnimatingDelegate?
    public var loadingDescription: String? {
        didSet {
            enableAccessibility(label: loadingDescription!)
        }
    }
    
    public func sceneIsPresented() {
        let imgs = Title.backgrounds.map { return Image(with: $0) }
        titleCard.animate(with: imgs, fps: 2, loop: true)
        
        let btns = Title.play.map { return Image(with: $0) }
        playButton = GraphicButton(images: (btns[0], btns[1], nil), name: "Play Button") {
            self.animationDelegate?.sceneDidFinishAnimations(self)
        }
        playButton?.enableAccessibility(label: "Start Playing. Button.", select: true)
        self.place(playButton!, at: Point(x:0, y: -224))
        
        animationDelegate?.sceneDidLoad(self)
        
    }
    
    public func sceneWillDismiss() {
        
    }
}
